# -*- coding: utf-8 -*-
"""
Created on Sun May  9 23:09:36 2021

@author: Fabien
"""

import pandas as pd
from sklearn import linear_model
from sklearn import metrics
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap
plt.ion()

dataset = pd.read_csv("datas/Reseaux_sociaux_auto.csv")
Xt = dataset[["Salaire", "Age"]].to_numpy(dtype=float)
yt = dataset[["Achat"]].to_numpy()
yt = yt.reshape((yt.shape[0], 1))
Xt[:,0]=Xt[:,0]/1000.

# TRACE DU DATASET
plt.close('all')
fig, ax = plt.subplots()
scatter = ax.scatter(Xt[:,0], Xt[:,1], c=yt, cmap = ListedColormap(['r','b']))
legend1 = ax.legend(*scatter.legend_elements(), loc="best", title="Classes")
ax.add_artist(legend1)
plt.xlabel("Salaire"); plt.ylabel("Age")

# ENTRAINEMENT DU MODELE
Modele_RL = linear_model.LogisticRegression()
# penalty='none')
yt=yt.ravel()
Modele_RL.fit(Xt, yt)

### TRACES GRAPHIQUES ###
resolution = 500
#limites du graphique
x0lim = (min(Xt[:,0])-10,max(Xt[:,0])+10)
x1lim = (min(Xt[:,1])-10,max(Xt[:,1])+10)
# meshgrid
x0 = np.linspace(x0lim[0], x0lim[1], resolution)
x1 = np.linspace(x1lim[0], x1lim[1], resolution)
X0, X1 = np.meshgrid(x0, x1)
# assembler les 2 variables
XX = np.vstack((X0.ravel(), X1.ravel())).T
# Prédictions
Z = Modele_RL.predict(XX)
Z = Z.reshape((resolution, resolution))
ax.pcolormesh(X0, X1, Z, alpha=0.2) #alpha : transparence...
ax.contour(X0, X1, Z, colors='k') # Frontière

# MATRICE DE CONFUSION
metrics.ConfusionMatrixDisplay.from_predictions(yt, Modele_RL.predict(Xt))